/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.golemoverhaul.common.entities.golems;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Crackiness;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import tech.alexnijjar.golemoverhaul.common.constants.ConstantAnimations;
import tech.alexnijjar.golemoverhaul.common.entities.golems.base.BaseGolem;
import tech.alexnijjar.golemoverhaul.common.entities.projectiles.CandleFlameProjectile;
import tech.alexnijjar.golemoverhaul.common.tags.ModItemTags;

public class CandleGolem
extends BaseGolem
implements RangedAttackMob {
    private static final float HEALTH_LOSS_PER_SHOT = 0.02f;
    private static final EntityDataAccessor<Boolean> ID_LIT = SynchedEntityData.defineId(CandleGolem.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> ID_SITTING = SynchedEntityData.defineId(CandleGolem.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private final RangedAttackGoal rangedAttackGoal = new CandleGolemRangedAttackGoal(this, 1.0, 20, 15.0f);

    public CandleGolem(EntityType<? extends AbstractGolem> type, Level level) {
        super(type, level);
        this.xpReward = 4;
        this.navigation = new CandleGolemGroundPathNavigation();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 15.0).add(Attributes.MOVEMENT_SPEED, 0.3).add(Attributes.ATTACK_DAMAGE, 3.0);
    }

    @Override
    public PlayState getMoveAnimation(AnimationState<BaseGolem> state, boolean moving) {
        return state.setAndContinue(moving ? ConstantAnimations.WALK : (this.isSitting() ? ConstantAnimations.SITTING_IDLE : ConstantAnimations.IDLE));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(ID_LIT, (Object)false);
        builder.define(ID_SITTING, (Object)false);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("Lit", this.isLit());
        compound.putBoolean("Sitting", this.isSitting());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setLit(compound.getBoolean("Lit"));
        this.setSitting(compound.getBoolean("Sitting"));
    }

    @Override
    public boolean canMeleeAttack() {
        return !this.canBeLit();
    }

    @Override
    public boolean canTarget() {
        return this.isLit() || !this.canBeLit();
    }

    public boolean isLit() {
        return this.canBeLit() && (Boolean)this.entityData.get(ID_LIT) != false;
    }

    public void setLit(boolean lit) {
        this.entityData.set(ID_LIT, (Object)lit);
        this.goalSelector.removeGoal((Goal)this.rangedAttackGoal);
        if (lit) {
            this.goalSelector.addGoal(2, (Goal)this.rangedAttackGoal);
        }
        this.updateAttackGoals();
    }

    public boolean isSitting() {
        return (Boolean)this.entityData.get(ID_SITTING);
    }

    public void setSitting(boolean sitting) {
        this.entityData.set(ID_SITTING, (Object)sitting);
        this.getAttribute(Attributes.KNOCKBACK_RESISTANCE).setBaseValue(sitting ? 1.0 : 0.0);
    }

    public boolean canBeLit() {
        return this.getCrackiness() != Crackiness.Level.HIGH;
    }

    @Override
    public boolean hasAttackAnimation() {
        return false;
    }

    public void lavaHurt() {
        super.lavaHurt();
        this.setLit(true);
    }

    protected void actuallyHurt(DamageSource damageSource, float damageAmount) {
        if (damageSource.is(DamageTypeTags.IS_FIRE)) {
            this.setLit(true);
        }
        if (this.isSitting()) {
            damageAmount *= 0.1f;
        }
        super.actuallyHurt(damageSource, damageAmount);
        this.updateAttackGoals();
    }

    public void extinguishFire() {
        super.extinguishFire();
        if (this.isLit()) {
            this.setLit(false);
            this.playSound(SoundEvents.FIRE_EXTINGUISH, 1.0f, 2.0f);
        }
    }

    @Override
    public int getAttackTicks() {
        return 10;
    }

    @Override
    public boolean canRepair(ItemStack stack) {
        return stack.is(ModItemTags.WAX);
    }

    @Override
    public float getRepairItemHealAmount() {
        return 5.0f;
    }

    @Override
    public SoundEvent getRepairSound() {
        return SoundEvents.HONEYCOMB_WAX_ON;
    }

    public void performRangedAttack(LivingEntity target, float velocity) {
        CandleFlameProjectile projectile = new CandleFlameProjectile(this.level(), (LivingEntity)this);
        projectile.setPos(this.getX(), this.getY() + 0.5, this.getZ());
        double x = target.getX() - this.getX();
        double y = target.getY() - projectile.getY();
        double z = target.getZ() - this.getZ();
        double distance = Math.sqrt(x * x + z * z) * 0.2;
        projectile.shoot(x, y + distance, z, 0.4f, 5.0f);
        this.level().addFreshEntity((Entity)projectile);
        this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.BLAZE_SHOOT, this.getSoundSource(), 0.3f, this.random.nextFloat() * 0.4f + 0.8f);
        this.setHealth(this.getHealth() - 0.02f);
    }

    public void tick() {
        if (this.isSitting()) {
            this.setDeltaMovement(0.0, this.getDeltaMovement().y(), 0.0);
            this.navigation.stop();
        }
        super.tick();
        if (this.level().isClientSide()) {
            if (this.isLit() && this.tickCount % 10 == 0) {
                this.level().addParticle((ParticleOptions)ParticleTypes.FLAME, this.getX(), this.getY() + 0.4, this.getZ(), 0.0, 0.02, 0.0);
            }
        } else if (this.isInWaterOrRain()) {
            this.setLit(false);
        }
    }

    @Override
    @NotNull
    protected InteractionResult mobInteract(Player player, @NotNull InteractionHand hand) {
        if (super.mobInteract(player, hand).consumesAction()) {
            return InteractionResult.SUCCESS;
        }
        if (this.level().isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        ItemStack stack = player.getItemInHand(hand);
        if (!player.isShiftKeyDown() && stack.isEmpty()) {
            this.setSitting(!this.isSitting());
            return InteractionResult.SUCCESS;
        }
        if (this.isLit()) {
            if (stack.isEmpty()) {
                this.extinguishFire();
                return InteractionResult.SUCCESS;
            }
        } else if (this.canBeLit()) {
            if (stack.is(Items.FLINT_AND_STEEL)) {
                stack.hurtAndBreak(1, (LivingEntity)player, CandleGolem.getSlotForHand((InteractionHand)hand));
                this.playSound(SoundEvents.FLINTANDSTEEL_USE);
                this.setLit(true);
                return InteractionResult.SUCCESS;
            }
            if (stack.is(Items.FIRE_CHARGE)) {
                stack.shrink(1);
                this.playSound(SoundEvents.FIRECHARGE_USE);
                this.setLit(true);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    protected AABB getAttackBoundingBox() {
        return super.getAttackBoundingBox().inflate(0.25, 0.0, 0.25);
    }

    private class CandleGolemRangedAttackGoal
    extends RangedAttackGoal {
        public CandleGolemRangedAttackGoal(RangedAttackMob rangedAttackMob, double speedModifier, int attackInterval, float attackRadius) {
            super(rangedAttackMob, speedModifier, attackInterval, attackRadius);
        }

        public boolean canUse() {
            return CandleGolem.this.canBeLit() && super.canUse();
        }
    }

    private class CandleGolemGroundPathNavigation
    extends GroundPathNavigation {
        public CandleGolemGroundPathNavigation() {
            super((Mob)CandleGolem.this, CandleGolem.this.level());
        }

        protected boolean canUpdatePath() {
            return !CandleGolem.this.isSitting() && super.canUpdatePath();
        }

        public boolean moveTo(@Nullable Path path, double speed) {
            return !CandleGolem.this.isSitting() && super.moveTo(path, speed);
        }
    }
}

